<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingCalculatorBase\Api;

/**
 * Interface which organize information about customer default address
 */
interface AddressResolverInterface
{
    /**
     * Get default country id
     *
     * @return string
     */
    public function getCountryId(): string;

    /**
     * Get default region id or code
     *
     * @return string
     */
    public function getRegionId(): string;

    /**
     * Get default zip (postal) code
     *
     * @return string
     */
    public function getZipCode(): string;
}