<?php
/**
 * Magento 2 Google Analytics 4 for Magento 2 GA4
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec4
 * @copyright 	Copyright (c) 2025 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec4\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;

class Purchase implements ObserverInterface
{
    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\CollectionFactory
     */
    protected $orderCollectionFactory;

    /**
     * @var \Magento\Framework\App\ResourceConnection
     */
    protected $resourceConnection;
    
    /**
     * Constructor 
     * 
     * @param \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory
     */
    public function __construct
    (
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory,
        \Magento\Framework\App\ResourceConnection $resourceConnection
    )
    {
        $this->orderCollectionFactory = $orderCollectionFactory;
        $this->resourceConnection = $resourceConnection;
    }
    
    /**
     * Add order information into GA block to render on checkout success pages
     *
     * @param EventObserver $observer
     * @return void
     */
    public function execute(EventObserver $observer)
    {
        /**
         * Get payload response
         * 
         * @var array $response
         */
        $response = $observer->getTransport()->getResponse();
        
        /**
         * Get order
         * 
         * @var \Magento\Sales\Model\Order $order
         */
        $order = $observer->getTransport()->getOrder();
        
        /**
         * Get email
         * 
         * @var string $email
         */
        $email = $order->getCustomerEmail();
        
        if ($email)
        {
            try 
            {
                $connection = $this->resourceConnection->getConnection();

                $statuses = 
                [
                    \Magento\Sales\Model\Order::STATE_COMPLETE,
                    \Magento\Sales\Model\Order::STATE_CLOSED,
                    \Magento\Sales\Model\Order::STATE_PROCESSING
                ];

                /**
                 * Build quick select statment
                 */
                $select = $connection->select()->from($this->resourceConnection->getTableName('sales_order'), 'SUM(grand_total)')->where('customer_email = ?', $email)->where('status IN (?)', $statuses);


                /**
                 * Get grand total spent
                 * 
                 * @var float
                 */
                $total = (float) $connection->fetchOne($select);

                if ($total > 0)
                {
                    $response['ecommerce']['new_customer']              = false;
                    $response['ecommerce']['customer_lifetime_value']   = (float) $total;
                }
                else 
                {
                    $response['ecommerce']['new_customer']              = true;
                    $response['ecommerce']['customer_lifetime_value']   = (float) $order->getGrandTotal();
                }
            }
            catch (\Exception $e)
            {
                $response['ecommerce']['new_customer']              = false;
                $response['ecommerce']['customer_lifetime_value']   = (float) $order->getGrandTotal();
            }
            
            $observer->getTransport()->setResponse($response);
        }
    }
}