<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Helper;

use Anowave\Ec\Helper\Affiliation;

class Attributes
{
	/**
	 * @var Affiliation
	 */
	protected $affiliation;
	
	/**
	 * Constructor 
	 * 
	 * @param Affiliation $affiliation
	 * @param array $data
	 */
	public function __construct
	(
		Affiliation $affiliation,
		array $data = []
	)
	{
		/**
		 * Set affiliation 
		 * 
		 * @var Affiliation $affiliation
		 */
		$this->affiliation = $affiliation;
	}
	
	/**
	 * Get affiliation
	 *
	 * @return string
	 */
	public function getAttributes()
	{
		return array_merge([],$this->affiliation->getAffiliationArray());
	}
}