<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ism;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class PutPolicy extends AbstractEndpoint
{
    protected $policy_id;

    public function getURI(): string
    {
        if (!isset($this->policy_id) || $this->policy_id === '') {
            throw new RuntimeException('policy_id is required for put_policy');
        }
        $policy_id = $this->policy_id;

        return '/_plugins/_ism/policies/' . rawurlencode($policy_id);
    }

    public function getParamWhitelist(): array
    {
        return [
            'if_primary_term',
            'if_seq_no',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setPolicyId($policy_id): static
    {
        if (is_null($policy_id)) {
            return $this;
        }
        $this->policy_id = $policy_id;

        return $this;
    }
}
