# Changelog

All notable changes to this project will be documented in this file.

## [201.6.0.25410] - 18/06/2025

### Fixed

- Fixed issue when module is disable still interfering with JS code

## [201.5.9] - 18/06/2025

### Fixed

- Fixed potential recurssion issue

## [201.5.8] - 16/06/2025

### Fixed

- Removed 'mixed' typehints to ensure backwards compat with php 7+


## [201.5.7] - 29/05/2025

### Fixed

- Fixed wrong path to "ee4 ecommerce purchase affiliation" in GTM API variable

## [201.5.6] - 29/05/2025

### Fixed

- Fixed potential recurssion issue with add_to_cart event

## [201.5.5] - 21/05/2025

### Fixed

- Changed client_id for refund requests to match the original client_id extracted from _ga cookie

## [201.5.4] - 21/05/2025

### Fixed

- Fixed measurement protocol issue related to new _ga_ cookie format e.g. (GS2.1.s<session_id>o1$g0$t1747132655$j0$l0$h0)
- Fixed minor PHP 8.4 compatibility issue in the REST protocol

## [201.5.3] - 19/05/2025

### Added

- Fixed minor PHP 8.4 compilation issue

## [201.5.1] - 16/05/2025

### Added

- Added support for PHP 8.4

## [201.5.0] - 12/05/2025

### Fixed 

- Fixed a bug from version 104.8.7 related to add_to_cart not firing for configurable products

## [201.4.9] - 12/05/2025

### Fixed 

## [201.4.8] - 12/05/2025

### Fixed 

- Fixed events not firing on Onetrust consent

## [201.4.7] - 07/05/2025

### Fixed 

- Fixed class case issue

## [201.4.6] - 07/05/2025

### Fixed 

- Fixed an error in cart page from version 201.4.2 preventing items from being removed from cart

## [201.4.5] - 07/05/2025

### Added

- Performance updates

## [201.4.4] - 07/05/2025

### Added

- Added abiltity to map Onetrust OpenanonGroups with built-in consent mode to allow for showing Onetrust consent selection in sales order grid


## [201.4.3] - 05/05/2025

### Fixed

- Fixed OneTrust support not firing some events such as add_payment_info, add_shipping_info

### Added

- Improved OneTrust support and linked consent to internal consent to display it in sales order grid

## [201.4.2] - 28/04/2025

### Fixed

- Fixed JS error caused by double quote

## [201.4.1] - 28/04/2025

### Fixed

- Removed a few instances of eval() used in code. Replaced with safer Function() call.

## [201.4.0] - 10/04/2025

### Added

- Optimisations, size reduction

### Fixed

- Fixed a typo in items[] array for TikTok Purchase tracking

## [201.3.9] - 10/04/2025

### Added

- Added full support for TikTok Pixel tracking

## [201.3.8] - 08/04/2025

### Added

- Added opt-in/opt-out config option for consent mode. Opt-in mode will set 'default' state to 'denied' always.

## [201.3.7] - 18/03/2025

### Added

- Added new option to allow for hashing email for login events

## [201.3.6] - 18/03/2025

### Added

- Added ability to add link[rel="preconnect"] tags for both GA4 and GTM

## [201.3.5] - 18/03/2025

### Added

- Added pageName parameter
- Added pageType eq 'checkout' for hyva_checkout

## [201.3.4] - 13/03/2025

### Fixed

- Fixed compatibility with third party AJAX carts

## [201.3.3] - 12/03/2025

### Fixed

- Fixed compatibility issue with extensions altering $.mage.priceBox widget

## [201.3.2] - 04/03/2025

### Fixed

- Removed a wrong factory constructor in Model/Cache.php

## [201.3.1] - 25/02/2025

### Fixed

- Fixed Uncaught TypeError: Assignment to constant variable.

## [201.3.0] - 24/02/2025

### Fixed

- Fixed missing nonce parameter to gtag()

### Added

- Added new dataLayer[] variables through the API to ease manual Google Ads Conversion Tracking + Enhanced Conversion Data

## [201.2.9] - 19/02/2025

### Fixed

- Fixed db table collation issue

## [201.2.8] - 19/02/2025

### Fixed

- Fixed cookie law script loading
- Fixed some racing issues

### Added

- Added ability to send server-side Conversion Enhancements via Google Ads API using delayed task (cron)

## [201.2.7] - 03/02/2025

### Fixed

- Fixed Adobe Cloud issue

## [201.2.6] - 31/01/2025

### Fixed

- Removed a reused constant reference to Anowave_Consent extension

## [201.2.5] - 30/01/2025

### Fixed

- Fixed a small issue related to missing default value for new setting (Cookie Consent custom css, getCookieDirectiveContentCss())

## [201.2.4] - 30/01/2025

### Fixed

- Fixed small return type issue

## [201.2.3] - 30/01/2025

### Fixed

- Fixed but appearing in Adobe Cloud only in Utils::getTree() method

## [201.2.2] - 28/01/2025

### Added

- Added ability to add SVG or raster logo in the cookie consent popup
- Added new feature called 'Self assesment' to ease identifying 3rd party cookies that are not blocked
- Improved Cookie Law users guides
- Added ability to automatically block GTM snippet if native cookie consent is enabled
- Added ability to display cookie information in the popup widget

### Changed

- If native consent mode is enabled, the extension will change the GTM snippet script type to text/template and add data-consent attribute to make it fire on consent granted

## [201.2.1] - 23/01/2025

### Added

- Added ability to display cookie usage inside the Cookie Widget popup (if used)
- Added some more information regarding cookie law compliance
- Added automatic script detection for scripts added in Content -> Design -> Configuration -> HTML Head

## [201.2.0] - 20/01/2025

### Fixed

- Changed Data::getRatingSummary() method to use direct SQL queries to optimize rating loading

## [201.1.9] - 17/01/2025

### Fixed

- Fixed some performance issues linked to large carts
- Fixed access to category data
- Optimized access to product reviews/rating summary

## [201.1.8] - 30/12/2024

### Added

- Added config option to switch between RoaS and PoaS strategy for both Google Ads and GA4

## [201.1.7] - 30/12/2024

### Added

- Added new option to override current currency with fixed currency to overcome GA4 convertion rate issues.

## [201.1.6] - 18/12/2024

### Fixed

- Added 'value' to ecommerce[] key in begin_checkout event

### Added

- Added ability to convert prices and set fixed currency for transactions
- Added ability to convert prices and set fixed currency for API calls

(See Stores -> Configuration -> Anowave -> Google Tag Manager -> Currency panel)

## [201.1.5] - 17/12/2024

### Added

- Added Google Ads API Enhanced Conversion support
- Added Google Ads API Conversion Adjustment support
- Added Google Ads API Conversion Health stats in dashboard

## [201.1.4] - 10/12/2024

### Removed

- Removed impressions[] key push into view_item event

### Added

- Added option to include related[] key payload to view_item event (See Stores -> Configuration -> Anowave -> Google Tag Manager GA4 -> Enhanced Ecommerce Tracking Preferences -> Add related[] option)
- Added option to include updsells[] key payload to view_item event 

## [201.1.3] - 04/12/2024

### Added

- Added adminId push into dataLayer[] to allow for checking for 'Logged as Customer' placed orders.
- Added ViewCategory event in CAPI (Meta Conversion API)


## [201.1.2] - 03/12/2024


### Fixed

- Fixed some performance issues

### Added

- BETA: Optional ability to offload some tasks in Web worker. New option: Use Web worker

## [201.1.1] - 21/11/2024

### Fixed

- Small Google Ads API fixes

## [201.1.0] - 21/11/2024

### Added

- Added Google Ads API Enhanced Conversion Tracking (BETA)
- Added missing add_to_cart event from product compare page
- Added a few new attributes for the page_view event:

a) clientStatus
b) hashed_email
c) user_id
d) websiteCountry
e) websiteLanguage
f) page_mid_category (for category pages)
g) page_top_category  (for category pages)

## [201.0.8] - 21/11/2024

### Fixed

- Minor updates

## [201.0.7] - 15/11/2024

### Added

- Fixed wrong parameters in public function afterGetData(\Anowave\Ec\Block\Comment $block, $result, $key = '', $index = null)


## [201.0.6] - 28/10/2024

### Added

- Added new option to allow disabling view_item event for GROUPED product

## [201.0.5] - 25/10/2024

### Added

- Added google_business_vertical eq 'retail' to events

## [201.0.4] - 24/10/2024

### Added

- Added automatic script tagging for consent law
- Added script converter tool to ease manual tagging for consent law

## [201.0.3] - 15/10/2024

### Added

- Added CONSENT column in sales order grid

### Fixed

- Fixed cookie lifetime for consentUuid cookie

## [201.0.2] - 15/10/2024

### Fixed

- Fixed console warning - jQuery.Deferred exception: this.wishlist().items is undefined

## [201.0.1] - 15/10/2024

### Added

- Added ability to fire view_item event for each associated product from a group. 

## [201.0.0] - 14/10/2024

### Fixed

- Fixed a small bug related to issueing creding memos with deleted products

## [200.9.9] - 23/09/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.9] related updates

## [200.9.8] - 18/09/2024

### Added

- Added CSP header size checker to avoid 500 Premature end of headers issue

## [200.9.7] - 18/09/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.8] related updates

## [200.9.6] - 16/09/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.7] related updates

## [200.9.5] - 10/09/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.6] related updates

## [200.9.4] - 06/09/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.5] related updates

## [200.9.3] - 05/09/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.4] related updates

## [200.9.2] - 26/08/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.3] related updates

## [200.9.1] - 15/08/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.2] related updates

## [200.9.0] - 23/07/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.1] related updates

## [200.8.9] - 27/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.3.0] related updates

## [200.8.8] - 27/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.9] related updates

## [200.8.7] - 27/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.8] related updates

## [200.8.6] - 27/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.7] related updates

## [200.8.5] - 26/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.6] related updates

## [200.8.4] - 24/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.5] related updates

## [200.8.3] - 11/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.4] related updates

## [200.8.2] - 03/06/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.3] related updates

## [200.8.1] - 21/05/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.2] related updates

## [200.8.0] - 15/05/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.1] related updates

## [200.7.9] - 10/05/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.2.0] related updates

## [200.7.8] - 08/05/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.9] related updates

## [200.7.7] - 03/05/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.8] related updates

## [200.7.6] - 01/05/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.7] related updates

## [200.7.5] - 01/05/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.6] related updates

## [200.7.4] - 25/04/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.5] related updates

## [200.7.3] - 15/04/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.3] related updates

## [200.7.2] - 09/04/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.2] related updates

## [200.7.1] - 09/04/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.1] related updates

## [200.7.0] - 28/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.1.0] related updates

## [200.6.9] - 28/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.9] related updates

## [200.6.8] - 20/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.8] related updates

## [200.6.7] - 20/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.7] related updates

## [200.6.6] - 20/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.6] related updates

## [200.6.4] - 08/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.4] related updates

## [200.6.3] - 08/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.3] related updates

## [200.6.2] - 08/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.2] related updates

## [200.6.1] - 08/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.1] related updates

## [200.6.0] - 07/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [104.0.0] related updates

## [200.5.9] - 06/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.9] related updates

## [200.5.8] - 06/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.8] related updates

## [200.5.7] - 05/03/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.7] related updates

## [200.5.6] - 28/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.6] related updates

## [200.5.5] - 28/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.5] related updates

## [200.5.4] - 28/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.4] related updates

## [200.5.3] - 27/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.3] related updates

## [200.5.2] - 27/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.2] related updates

## [200.5.1] - 27/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.1] related updates

## [200.5.0] - 22/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.9.0] related updates

## [200.4.9] - 22/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.9] related updates

## [200.4.8] - 21/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.8] related updates

## [200.4.7] - 21/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.7] related updates

## [200.4.6] - 19/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.6] related updates

## [200.4.5] - 19/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.5] related updates

## [200.4.4] - 14/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.4] related updates

## [200.4.3] - 14/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.3] related updates

## [200.4.2] - 09/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.2] related updates


## [200.4.1] - 09/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.1] related updates

## [200.4.0] - 06/02/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.8.0] related updates

## [200.3.9] - 06/02/2024

### Added

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.7.9] related updates

## [200.3.8] - 02/02/2024

### Added

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.7.8] related updates

## [200.3.7] - 29/01/2024

### Fixed

- See \app\code\Anowave\Ec\CHANGELOG.md for ## [103.7.7] related updates

## [200.3.6] - 25/01/2024

### Added

- Added bundles[] array to items[] array for purchas event payload

## [200.3.5] - 18/01/2024

### Added

- Fixed a $.mage.sidebar widget issue
- Fixed pricing rendering issue.

## [200.3.4] - 09/01/2024

### Added

- Added Consent Mode V2 support (ad_user_data,ad_personalization) in SEGMENT mode

## [200.3.3] - 19/12/2023

### Fixed

- Fixed Cannot instantiate abstract class Anowave\Ec\Model\ResourceModel\Consent\Grid\Collection error

## [200.3.2] - 12/12/2023

### Fixed

- Disabled loading of AEC() object when module is disabled from confg

## [200.3.1] - 11/12/2023

### Fixed

- Fixed a JS error related to price-box.js when module is disabled from config

## [200.3.0] - 30/11/2023

### Added

- Added new option in Advanced Developer Configuration called 'Optimize scripts' which if enabled will render scripts inline (HYVA style)

## [200.2.9] - 29/11/2023

### Added

- Added ability to keep 'purchase' event when Track SERVER-SIDE Only option is enabled.
- Added session_id to measurement protocol request params[]

## [200.2.8] - 16/11/2023

### Fixed

- Fixed a typo in gtag('consent','updated') to gtag('consent,'update') prevening Consent Mode to firing properly

## [200.2.7] - 01/11/2023

### Fixed

- Fixed wrong payload in Search results

## [200.2.6] - 01/11/2023

### Fixed

- Fixed small JS error triggering for swatches only

## [200.2.5] - 24/10/2023

### Fixed

- Fixed FCAPI notice issue

## [200.2.4] - 20/10/2023

### Fixed

- Fixed a JS issue related to old UA
- Fixed an issue related to Ad-Blocker Fallback feature (new GA4 specs).

## [200.2.3] - 19/10/2023

### Fixed

- Fixed wrong host message for store view config scope

## [200.2.2] - 17/10/2023

### Changed

- Module is now pulling measurement client id from _ga() cookie or generating randome one if cookie isn't set

## [200.2.1] - 16/10/2023

### Fixed

- Fixed compilation issue

## [200.2.0] - 16/10/2023

### Fixed

- Fixed a typo in config

## [200.1.9] - 16/10/2023

### Fixed

- Fixed minor Measurement Protocol issues

## [200.1.8] - 11/10/2023

### Added

- Added discount amount in purchase payload

## [200.1.7] - 11/10/2023

### Fixed

- Fixed a nasty issue with DataPatch related to table prefixes

## [200.1.6] - 11/10/2023

### Fixed

- Added missing item_list_id and item_list_name parameters for server-side (Measurement Protocol) transaction tracking.

## [200.1.5] - 05/10/2023

### Fixed

- Fixed a small typo

## [200.1.4] - 05/10/2023

### Fixed

- Fixed a small JS error (extra ';') character causing issues with compressed code. (ec.js)

## [200.1.3] - 05/10/2023

### Fixed

- Updated Anowave_Ec to version ## [103.7.4] - 05/10/2023 (see app/code/Anowave/Ec/CHANGELOG.md for more details)


## [200.1.2] - 05/10/2023

### Added

- Added Patch to copy existing license keys to new config path

## [200.1.1] - 05/10/2023

### Added

- Updated Anowave_Ec to version ## [103.7.3] - 05/10/2023 (see app/code/Anowave/Ec/CHANGELOG.md for more details)

## [200.1.0] - 05/10/2023

### IMPORTANT

- After updating to 200.1.0 check if license keys work, check if GTM snippet is still loaded on page to ensure that tracking will continue working

### MAJOR CHANGES

- Removed former UA (GA3) payload pushes in favour of the new GA4 pushes
- Removed JS dataLayer[] modifications (no longer needed because payload produced by Anowave_Ec is now GA4 only)


### Merged

- Merged configurations into single configuration screen
- Replaced MAGE2-GTM license with the one from MAGE2-GTMGA4 license
- Added a patch to copy existing license keys related to MAGE2-GTM into MAGE2-GTMGA4 to prevent tracking interuptions

## [200.0.4] - 27/09/2023

### Changed

- Remove most of the dataLayer[] alternations which were based on JS

## [200.0.3] - 27/09/2023

### Added

- Updated Anowave_Ec module (added 2 new tax calculation options)

(see app/code/Anowave/Ec/CHANGELOG.md for more information)

## [200.0.2] - 21/09/2023

### Fixed

- Updated Anowave_Ec package

## [200.0.1] - 20/09/2023

### Fixed

- Updated Anowave_Ec module (see app/code/Anowave/Ec/CHANGELOG.md for more information) 

## [200.0.0] - 20/09/2023

### Merged 

- Merged Anowave_Ec and Anowave_Ec4 into single downloadable ZIP file. All updates will be delivered to Anowave_Ec4 package from now on.

## [100.9.0] - 07/09/2023

### Fixed

- Fixed small JS error in case when product isn't assigned to any category

## [100.8.9] - 04/08/2023

### Added

- Added support for new customer acquisition reporting (https://support.google.com/google-ads/answer/12077475)

## [100.8.8] - 20/07/2023

### Fixed

- Added missing item_list_id and item_list_name attributes for add_to_wishlist event

## [100.8.7] - 20/07/2023

### Fixed

- Fixed wrong Measurement ID for multi-store refunds

## [100.8.6] - 10/07/2023

### Fixed

- Added missing item_list_id and item_list_name in purchase payload

## [100.8.5] - 30/06/2023

### Fixed

- Fixed PHP 8.2 related issue with refunds (deprecated utf8_encode)

## [100.8.4] - 06/06/2023

### Fixed

- Fixed Anowave_Ec compatibility issue

## [100.8.3] - 01/06/2023

### Fixed

- Added PHP 8.2 support

## [100.8.2] - 25/05/2023

### Fixed

- Added string cast to some null values

## [100.8.1] - 25/05/2023

### Fixed

- Fixed a few PHP8 compatibility issues

## [100.8.0] - 24/05/2023

### Added

- Added custom event 'ec_view_cart' to allow third parties to modify view_cart payload

## [100.7.9] - 24/05/2023

### Fixed

- Performance updates

## [100.7.8] - 24/05/2023

### Fixed

- JS code cleanup

## [100.7.7] - 24/05/2023

### Fixed

- Added ability to import user-scoped properties from UA to GA4 items[] array

## [100.7.6] - 14/05/2023

### Fixed

- Fixed GDRP compliance

## [100.7.5] - 18/04/2023

### Fixed

- Fixed a multi-store issue related to admin orders going to wrong Measurement ID

## [100.7.4] - 28/03/2023

### Fixed

- Fixed wrong 'value' parameter linked to begin_checkout event

## [100.7.3] - 01/03/2023

### Fixed

- Added mising 'value' parameter to begin_checkout

## [100.7.2] - 22/02/2023

### Fixed

- Replaced coupon rule name with coupon code in begin_checkout payload

## [100.7.1] - 20/02/2023

### Fixed

- Added missing 'value' parameter to view_cart event
- Moved 'currency' parameter to ecommerce[] in view_cart event

## [100.7.0] - 09/02/2023

### Fixed

- Removed last underscore from item_category[N] (replaced item_category_[N] to item_category[N]) where N is the catgeory level 

## [100.6.9] - 03/02/2023

### Added

- Added google_business_vertical to items[] array

## [100.6.8] - 02/02/2023

### Fixed

- Small bug fix

## [100.6.7] - 02/02/2023

### Added

- Added missing 'coupon' & 'currency' values for begin_checkout, add_payment_info, add_shipping_info events

## [100.6.6] - 23/01/2023

### Fixed

- Fixed wrong 'affiliation' parameter for admin orders

## [100.6.5] - 20/01/2023

### Fixed

- Fixed promotion tracking issue related to items[] array

## [100.6.4] - 20/01/2023

### Added

- Added promotion tracking (BETA)

## [100.6.3] - 19/01/2023

### Fixed

- Fixed an issue with refunds when product isn't added to any category

## [100.6.2] - 16/12/2022

### Added

- Added items[].affiliation parameter to support affiliations

## [100.6.1] - 15/12/2022

### Fixed

= Fixed TypeError: Anowave\Ec4\Plugin\Api\Measurement\Protocol::afterGetUA(): Argument #3 ($order) must be of type Magento\Sales\Model\Order, null given error

## [100.6.0] - 13/12/2022

### Fixed

- Fixed Uncaught TypeError: reference is null error on cart page

## [100.5.9] - 07/11/2022

### Fixed

- Fixed Uncaught TypeError: reference is null error

## [100.5.8] - 30/11/2022

### Fixed

- Fixed inconsistent category between events

## [100.5.7] - 29/11/2022

### Fixed

- Fixed discrepancy between category set in view_cart and view_item/view_item_list events (based on local storage feature)

## [100.5.6] - 27/11/2022

### Fixed

- Fixed compatibility with Anowave_Ec (103.1.3)

## [100.5.5] - 18/11/2022

### Fixed

- Fixed an issue with categories in multi-store

## [100.5.4] - 16/11/2022

### Fixed

- Fixed error related to credit memos/refunds

## [100.5.3] - 04/11/2022

### Fixed

- Fixed wrong events related to cart update

## [100.5.2] - 28/09/2022

### Fixed

- Fixed wrong items[] parameter in add_to_wishlist event

## [100.5.1] - 05/09/2022

### Fixed

- Improved view_cart parameters

## [100.5.0] - 01/09/2022

### Fixed

## [100.4.9] - 24/08/2022

### Fixed

- Fixed wrong 'index' for widgets

## [100.4.8] - 18/08/2022

### Fixed

- Fixed item_category start index (previously starting from 1)

## [100.4.7] - 15/08/2022

### Fixed

- Updated consistency of 'item_list' and 'item_list_id'

## [100.4.6] - 01/8/2022

### Fixed

- Fixed a JS error in ec4.js related to impression payload

## [100.4.5] - 22/07/2022

### Fixed

- Added custom product identity tags 6342

## [100.4.4] - 08/06/2022

### Fixed

- Removed redundant Anowave_Package 

## [100.4.3] - 17/05/2022

### Fixed

- Removed redundant code

## [100.4.2] - 16/05/2022

### Fixed

- Added revserse transaction support

## [100.4.1] - 13/05/2022

### Fixed

- Fixed transaction_id discrepancy with cancel order

## [100.4.0] - 09/05/2022

### Fixed

- Fixed transaction_id discrepancy related to refund requests

## [100.3.9] - 08/05/2022

### Fixed

- Fixed minor typos in configuration interface and helpers

## [100.3.8] - 02/05/2022

### Added

- Added User Guide link in configuration to help starters with GA4

## [100.3.7] - 29/04/2022

### Added

- Added support for tracking native widgets

## [100.3.6] - 29/04/2022

### Added

- Added better compatibility with Anowave_Ec module

## [100.3.5] - 18/04/2022

### Added

- Added Measurement Protocol refund tracking

## [100.3.4] - 23/03/2022

### Fixed

- Fixed missing google_tag_params variable in GTM

## [100.3.3] - 23/03/2022

### Added

- Compatibility updates with Anowave_Ec

## [100.3.2] - 23/03/2022

### Added

- Added configuration option to allow for using shared or dedicated Measurement ID. Suitable for separating admin orders from frontend orders

## [100.3.1] - 22/03/2022

### Added

- Added 'traffic_type' parameter to Measurement Protocol purchase event

## [100.3.0] - 13/12/2022

### Added

- Added back EE AdWords Dynamic Remarketing tag
- Added back Event Equals Dynamic Remarketing trigger
- Added back ee conversion id and ee conversion label variables

## [100.2.9] - 01/12/2022

### Added

- Added add_to_compare event tracking
- Added new Event Equals Add To Compare trigger
- Added new EE Add To Compare tag

## [100.2.8] - 29/11/2022

### Fixed

- Fixed a JS error triggering on cart page

## [100.2.7] - 25/11/2022

### Added

- Added offline order tracking via Measurement Protocol 4

## [100.2.6] - 25/11/2022

### Fixed

- Fixed warning for missing UA-ID
- Added warning for unsupported refund tracking yet

## [100.2.5] - 21/09/2022

### Added

- Added view_cart event in cart page

## [100.2.4] - 30/08/2022

### Fixed

- Fixed duplicate begin_checkout event tracking

## [100.2.3] - 26/08/2022

### Fixed

- Removed conditional chaining to extend support for SAFARI

## [100.2.2] - 30/07/2022

### Added

- Added ability to change conversion event from 'purchase' to something else. This improves compatibility with Universal Analytics tracking using 'purchase' events

## [100.2.1] - 20/07/2022

### Fixed

- Minor composer.json updates

## [100.2.0] - 19/07/2022

### Fixed

- Fixed a composer.json psr-4 notation

## [100.1.9] - 18/05/2022

### Fixed

- Implemented some missing events (add_to_cart/remove_from_cart) related to mini-cart updates

## [100.1.8] - 23/04/2022

### Fixed

- Fixed some JS errors
- Added optional chaining to reduce JS errors caused by older Anowave_Ec versions

## [100.1.7] - 18/03/2022

### Fixed

- Small fixes

## [100.1.6] - 18/03/2022

### Fixed

- Fixed error - Uncaught exception 'TypeError' with message 'Argument 1 passed to Anowave\Ec\Helper\Data::getCategory() related to Wishlist

## [100.1.5] - 10/02/2022

### Added

- Added Add Payment Info/Add Shipping info triggers/variables etc.

## [100.1.4]

### Fixed

- Fixed wrong affiliation variable

## [100.1.3]

### Added

- Added new dataLayer[] variables in GTM -> Variables 

ee4 ecommerce purchase transaction id
ee4 ecommerce purchase value
ee4 ecommerce purchase currency
ee4 ecommerce purchase coupon
ee4 ecommerce purchase shipping
ee4 ecommerce purchase tax
ee4 ecommerce purchase affiliation

- Added missing 'transaction_id','value','coupon','tax','shipping' eventParameters to EE4 Purchase tag

## [100.1.2]

### Added

- Added {{ee4 ecommerce purchase items}} dataLayer[] variable

### Fixed

- Fixed missing 'items' eventParameter to ALL tags
- Fixed wrong value for 'items' eventParameter to EE4 purchase tag. (using {{ee4 ecommerce purchase items}} instead of {{ee4 ecommerce items}}

## [100.1.1]

### Fixed

- Fixed wrong event in EE View Item tag

## [100.1.0]

### Fixed

- Fixed productClick JS error

## [100.0.9]

### Fixed

- Minor updates

## [100.0.8]

### Fixed

- Fixed view_item event not firing properly

## [100.0.7]

### Added

- Added ability to turn on/off on demand for separate store views

## [100.0.6]

### Fixed

- Code refactor/minor updates

## [100.0.5]

### Fixed

- Fixed a mixed tags creation

## [100.0.4]

### Added

- Added view_item event

## [100.0.3]

### Added

- Added view_cart,add_to_wishlist events

## [100.0.2]

### Added

- Added add_payment_info, add_shipping_info events 

## [100.0.1]

### Fixed 

- Minor updates

### Added

- Added admin config menu

## [100.0.0]

- Initial version