<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Ui\DataProvider\Method\Form\Modifier;

use Magento\Framework\Registry;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;
use MageWorx\ShippingRules\Model\Carrier\Method;
use MageWorx\ShippingRules\Model\Carrier\MethodFactory;

/**
 * Class AbstractModifier
 */
abstract class AbstractModifier implements ModifierInterface
{
    public const FORM_NAME           = 'mageworx_shippingrules_method_form';
    public const DATA_SOURCE_DEFAULT = 'method';
    public const DATA_SCOPE_METHOD   = 'data.method';

    /**
     * Container fieldset prefix
     */
    public const CONTAINER_PREFIX = 'container_';

    /**
     * Meta config path
     */
    public const META_CONFIG_PATH = '/arguments/data/config';

    /**
     * @var ArrayManager
     */
    protected $arrayManager;

    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * @var MethodFactory
     */
    protected $methodFactory;

    /**
     * @var Registry
     */
    protected $registry;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param ArrayManager $arrayManager
     * @param UrlInterface $urlBuilder
     * @param MethodFactory $methodFactory
     * @param Registry $coreRegistry
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        ArrayManager          $arrayManager,
        UrlInterface          $urlBuilder,
        MethodFactory         $methodFactory,
        Registry              $coreRegistry,
        StoreManagerInterface $storeManager
    ) {
        $this->arrayManager  = $arrayManager;
        $this->urlBuilder    = $urlBuilder;
        $this->methodFactory = $methodFactory;
        $this->registry      = $coreRegistry;
        $this->storeManager  = $storeManager;
    }

    /**
     * Get current method or empty
     *
     * @return Method
     */
    protected function getMethod()
    {
        $method = $this->registry->registry(Method::CURRENT_METHOD);
        if (!$method) {
            $method = $this->methodFactory->create();
            $this->registry->register(Method::CURRENT_METHOD, $method, true);
        }

        return $method;
    }

    /**
     * Get currency symbol
     *
     * @return string
     */
    protected function getBaseCurrencySymbol()
    {
        return $this->storeManager->getStore()->getBaseCurrency()->getCurrencySymbol();
    }
}
