<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Model\Plugin;

use Magento\Shipping\Model\Config;
use MageWorx\ShippingRules\Model\Carrier\AbstractForValidation;

class AddValidationRules
{
    /**
     * @var AbstractForValidation
     */
    protected $abstractForValidation;

    /**
     * AddValidationRules constructor.
     *
     * @param AbstractForValidation $abstractForValidation
     */
    public function __construct(
        AbstractForValidation $abstractForValidation
    ) {
        $this->abstractForValidation = $abstractForValidation;
    }

    /**
     * Add empty abstract carrier to load own validation rules on the checkout page and cart page
     *
     * Workaround for the magento crutch where it unset all layout updates of inactive methods,
     * and this method is private (WTF?!):
     *
     * @param Config $subject
     * @param array $result
     * @return array
     * @see view/frontend/web/js/checkout/view/shipping-rates-validation/abstract.js
     *
     * @see \Magento\Checkout\Block\Checkout\LayoutProcessor::processShippingChildrenComponents()
     *
     *
     * @see view/frontend/web/js/checkout/model/shipping-rates-validation-rules/abstract.js
     * @see view/frontend/web/js/checkout/model/shipping-rates-validator/abstract.js
     */
    public function afterGetActiveCarriers(Config $subject, $result)
    {
        if (empty($result['mageworx-shipping'])) {
            $result['mageworx-shipping'] = $this->abstractForValidation;
        }

        return $result;
    }
}
