<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare(strict_types = 1);

namespace MageWorx\ShippingRules\Model\Rule\Attributes\Customer\Filters;

use Magento\Eav\Api\Data\AttributeInterface;
use MageWorx\ShippingRules\Api\CustomerAttributesFilterInterface;

/**
 * Disable customer attributes which has unsupported input type
 */
class ByInputType implements CustomerAttributesFilterInterface
{
    /**
     * Check is attribute disabled for conditions
     *
     * @param AttributeInterface $attribute
     * @return bool
     */
    public function check(AttributeInterface $attribute): bool
    {
        if (in_array($attribute->getFrontendInput(), ['file', 'image'])) {
            return false;
        }

        return true;
    }
}
