<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use MageWorx\ShippingRules\Api\Data\RateInterface;
use MageWorx\ShippingRules\Model\Carrier\Method\Rate;

/**
 * Extended Rate CRUD interface.
 *
 * @api
 */
interface RateRepositoryInterface
{
    /**
     * Save rate.
     *
     * @param Rate $rate
     * @return Rate
     * @throws LocalizedException
     */
    public function save(Rate $rate);

    /**
     * Retrieve rate.
     *
     * @param int $rateId
     * @return Rate
     * @throws LocalizedException
     */
    public function getById($rateId);

    /**
     * Retrieve rate by its code
     *
     * @param string $code
     * @return Rate|RateInterface
     * @throws NoSuchEntityException
     */
    public function getByCode($code);

    /**
     * Retrieve rates matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @param bool $returnRawObjects
     * @param bool $exportCollection
     * @return SearchResultsInterface
     */
    public function getList(
        SearchCriteriaInterface $searchCriteria,
                                $returnRawObjects = false,
                                $exportCollection = false
    );

    /**
     * Delete rate.
     *
     * @param Rate $rate
     * @return bool true on success
     * @throws LocalizedException
     */
    public function delete(Rate $rate);

    /**
     * Delete rate by ID.
     *
     * @param int $rateId
     * @return bool true on success
     * @throws NoSuchEntityException
     * @throws LocalizedException
     */
    public function deleteById($rateId);

    /**
     * Get empty Rate
     *
     * @return Rate|Data\RateInterface
     */
    public function getEmptyEntity();
}
