<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use MageWorx\ShippingRules\Api\Data\MethodInterface;
use MageWorx\ShippingRules\Model\Carrier\Method;

/**
 * Extended Method CRUD interface.
 *
 * @api
 */
interface MethodRepositoryInterface
{
    /**
     * Save method.
     *
     * @param Method $method
     * @return Method
     * @throws LocalizedException
     */
    public function save(Method $method);

    /**
     * Retrieve method.
     *
     * @param int $methodId
     * @return Method
     * @throws LocalizedException
     */
    public function getById($methodId);

    /**
     * Retrieve method by its code
     *
     * @param string $code
     * @return Method|MethodInterface
     * @throws NoSuchEntityException
     */
    public function getByCode($code);

    /**
     * Retrieve methods matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @param bool $returnRawObjects
     * @return SearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria, $returnRawObjects = false);

    /**
     * Delete method.
     *
     * @param Method $method
     * @return bool true on success
     * @throws LocalizedException
     */
    public function delete(Method $method);

    /**
     * Delete method by ID.
     *
     * @param int $methodId
     * @return bool true on success
     * @throws NoSuchEntityException
     * @throws LocalizedException
     */
    public function deleteById($methodId);

    /**
     * Get empty Method
     *
     * @return Method|Data\MethodInterface
     */
    public function getEmptyEntity();
}
