<?php
/**
 * Copyright © 2016 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\OptionFeatures\Model;

use Magento\Framework\Model\AbstractExtensibleModel;

class Image extends AbstractExtensibleModel
{
    public const TABLE_NAME = 'mageworx_optionfeatures_option_type_image';
    public const OPTIONTEMPLATES_TABLE_NAME = 'mageworx_optiontemplates_group_option_type_image';

    public const COLUMN_OPTION_TYPE_IMAGE_ID = 'option_type_image_id';
    public const COLUMN_OPTION_TYPE_ID       = 'option_type_id';
    public const COLUMN_MEDIA_TYPE     = 'media_type';
    public const COLUMN_VALUE      = 'value';
    public const COLUMN_TITLE_TEXT = 'title_text';
    public const COLUMN_SORT_ORDER = 'sort_order';
    public const COLUMN_BASE_IMAGE = 'base_image';
    public const COLUMN_TOOLTIP_IMAGE = 'tooltip_image';
    public const COLUMN_OVERLAY_IMAGE = 'overlay_image';
    public const COLUMN_COLOR         = 'color';
    public const COLUMN_REPLACE_MAIN_GALLERY_IMAGE = 'replace_main_gallery_image';
    public const COLUMN_HIDE_IN_GALLERY            = 'disabled';

    /**
     * Set resource model and Id field name
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->_init('MageWorx\OptionFeatures\Model\ResourceModel\Image');
        $this->setIdFieldName('option_type_image_id');
    }
}
