<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\DeliveryDate\Api;

use Magento\Quote\Api\Data\CartInterface;
use Magento\Quote\Model\Quote;

/**
 * Interface DefaultDeliveryDateManagerInterface
 *
 * Responsible to set default delivery date to a quote
 */
interface DefaultDeliveryDateManagerInterface
{
    /**
     * Adds default delivery date to the quote if it could be found using selected shipping method
     *
     * @param CartInterface|Quote $quote
     * @return void
     */
    public function addToQuote(CartInterface $quote);
}
