<?php
/**
 * Landofcoder
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Landofcoder.com license that is
 * available through the world-wide-web at this URL:
 * http://landofcoder.com/license
 * 
 * DISCLAIMER
 * 
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 * 
 * @category   Landofcoder
 * @package    Lof_ProductNotification
 * @copyright  Copyright (c) 2017 Landofcoder (http://www.landofcoder.com/)
 * @license    http://www.landofcoder.com/LICENSE-1.0.html
 */

namespace Lof\RequestForQuote\Setup;

use Magento\Framework\Module\Setup\Migration;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Eav\Setup\EavSetupFactory;

class InstallData implements InstallDataInterface
{
	/**
	 * @param GroupFactory $groupFactory 
	 */
	public function __construct(
		EavSetupFactory $eavSetupFactory
	) {
		$this->eavSetupFactory = $eavSetupFactory;
	}

	public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
	{
		$eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);
 		$data = array(
			'type'                          => 'int',
			'input'                         => 'boolean',
			'default'                       => 0,
			'label'                         => 'Enable Request Quote',
			'backend'                       => '',
			'frontend'                      => '',
			'source'                        => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
			'visible'                       => 1,
			'required'                      => 0,
			'user_defined'                  => true,
			'global'                    	 => \Magento\Catalog\Model\ResourceModel\Eav\Attribute::SCOPE_STORE,
			'searchable'					=> false,
			'filterable' 					=> false,
			'comparable' 					=> false,
			'visible_on_front' 				=> false,
			'used_in_product_listing' 		=> true,
			'unique' 						=> false,
			'apply_to' 						=> 'simple,configurable',
 			);
 		$eavSetup->addAttribute(
 			\Magento\Catalog\Model\Product::ENTITY,
 			'product_quote',
			 $data);
			 
			$canvasattributeset = $eavSetup->getAttributeSet(\Magento\Catalog\Model\Product::ENTITY,'CustomPrint');
			
			if($canvasattributeset != "" && !empty($canvasattributeset)){
				$canvasattributeGroupCode = $eavSetup->convertToAttributeGroupCode("Product Display Settings");
				$canvasattributeGroup = $eavSetup->getAttributeGroup(\Magento\Catalog\Model\Product::ENTITY, 'CustomPrint', $canvasattributeGroupCode, 'attribute_group_id');
				if($canvasattributeGroup == ""){
					$eavSetup->addAttributeGroup(\Magento\Catalog\Model\Product::ENTITY, 'CustomPrint', 'Product Display Settings', 25);
				}
				
				$eavSetup->addAttributeToGroup(\Magento\Catalog\Model\Product::ENTITY, 'CustomPrint', 'Product Display Settings', 'product_quote', 60);
				
			}

			$merchandiseattributeset = $eavSetup->getAttributeSet(\Magento\Catalog\Model\Product::ENTITY,'CustomProduct');
			if($merchandiseattributeset != "" && !empty($merchandiseattributeset)){
				$merchandiseattributeGroupCode = $eavSetup->convertToAttributeGroupCode("Product Display Settings");
				$merchandiseattributeGroup = $eavSetup->getAttributeGroup(\Magento\Catalog\Model\Product::ENTITY, 'CustomProduct', $merchandiseattributeGroupCode, 'attribute_group_id');
				if($merchandiseattributeGroup == ""){
					$eavSetup->addAttributeGroup(\Magento\Catalog\Model\Product::ENTITY, 'CustomProduct', 'Product Display Settings', 25);
				}
				
				$eavSetup->addAttributeToGroup(\Magento\Catalog\Model\Product::ENTITY, 'CustomProduct', 'Product Display Settings', 'product_quote', 60);
			}
	}
}
