<?php
namespace Chilliapple\AutoStatus\Cron;

use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;
use Magento\Sales\Model\Order\ShipmentFactory;
use Magento\Framework\DB\Expr;
use Magento\Framework\App\State;
use Psr\Log\LoggerInterface;

class AutoComplete
{
    protected $orderCollectionFactory;
    protected $shipmentFactory;
    protected $orderRepository;
    protected $_convertOrder;
    protected $logger;

    public function __construct(
        CollectionFactory $orderCollectionFactory,
        ShipmentFactory $shipmentFactory,
        OrderRepositoryInterface $orderRepository,
        \Magento\Sales\Model\Convert\Order $convertOrder,
        LoggerInterface $logger,
        State $state
    ) {
        $this->orderCollectionFactory = $orderCollectionFactory;
        $this->shipmentFactory = $shipmentFactory;
        $this->orderRepository = $orderRepository;
        $this->_convertOrder = $convertOrder;
        $this->logger = $logger;
        try {
            $state->setAreaCode('frontend');
        } catch (\Exception $e) {}
    }

    public function execute()
    {

        $this->logger->info("AutoComplete Cron Started");

        $date = new \DateTime();
        $date->modify('-1 hour');
        $oneHourAgo = $date->format('Y-m-d H:i:s');

        $orders = $this->orderCollectionFactory->create()
            ->addFieldToFilter('status', 'processing')
            ->addFieldToFilter('created_at', ['lteq' => $oneHourAgo]);

        foreach ($orders as $order) {
            try {

                //$order = $this->orderRepository->get($order->getId());

                if (!$order->canShip()) {
                    $this->logger->info("Order #{$order->getIncrementId()} cannot be shipped.");
                    continue;
                }

                $orderShipment = $this->_convertOrder->toShipment($order);
                foreach ($order->getAllItems() as $orderItem) {
                    // Check virtual item and item Quantity
                    if (!$orderItem->getQtyToShip() || $orderItem->getIsVirtual()) {
                        continue;
                    }
                    $qty = $orderItem->getQtyToShip();
                    $shipmentItem = $this->_convertOrder->itemToShipmentItem($orderItem)->setQty($qty);
                    $orderShipment->addItem($shipmentItem);
                }
                $orderShipment->register();
                $orderShipment->getOrder()->setIsInProcess(true);

                // Save created Order Shipment
                $orderShipment->save();
                $orderShipment->getOrder()->save();

                // Set status to complete
                $order->setState(\Magento\Sales\Model\Order::STATE_COMPLETE)
                      ->setStatus(\Magento\Sales\Model\Order::STATE_COMPLETE);
                $this->orderRepository->save($order);

                $this->logger->info("Order #{$order->getIncrementId()} shipped and completed.");

            } catch (\Exception $e) {
                $this->logger->error("Error processing Order #{$order->getIncrementId()}: " . $e->getMessage());
            }
        }

        $this->logger->info("AutoComplete Cron Finished");

    }

    private function getTrackingData($order)
    {
        return []; // You can add tracking details here if needed
    }
}
