<?php

namespace BG\DesignHuddle\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use BG\DesignHuddle\Helper\Data as Dhhelper;
use BG\DesignHuddle\Helper\Databgcollect as Databgcol;
use Magento\Framework\App\Request\Http;
use \BG\DesignHuddle\Model\CustomDesignFactory;

use Magento\Quote\Model\QuoteFactory;


//use Magento\Quote\Model\ResourceModel\Quote\Item\CollectionFactory as   QuoteFactory;

class CheckoutCartProductAddAfterObserver implements ObserverInterface
{
    protected $_layout;
    protected $_storeManager;
    protected $_request;
    protected $customerSession;
    protected $messageManager;
    protected $_responseFactory;
    protected $_url;

    protected $Dhhelper;

    protected $Databgcol;

    protected $quoteFactory;

    protected $request;

    protected $CustomDesignModel;

    public function __construct(
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\View\LayoutInterface $layout,
        \Magento\Framework\App\RequestInterface $request,
        Http $requesthttp,
        Dhhelper $Dhhelper,
        Databgcol $Databgcol,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\UrlInterface $url,
        \Magento\Customer\Model\Session $customerSession,
        QuoteFactory $quoteFactory,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        CustomDesignFactory $CustomDesignModel
    ) {
        $this->quoteFactory = $quoteFactory;
        $this->_layout = $layout;
        $this->_storeManager = $storeManager;
        $this->_request = $request;
        $this->Dhhelper = $Dhhelper;
        $this->Databgcol = $Databgcol;
        $this->request = $requesthttp;
        $this->customerSession = $customerSession;
        $this->CustomDesignModel = $CustomDesignModel;
        $this->messageManager = $messageManager;
        $this->_responseFactory = $responseFactory;
        $this->_url = $url;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        //try {
        $quoteItem = $observer->getEvent()->getData('quote_item');
        $product = $observer->getEvent()->getData('product');
        $requestParams = $quoteItem->getBuyRequest();
        if ($requestParams instanceof \Magento\Framework\DataObject  && is_object($requestParams)) {
            // buyRequestArray is inddex
            $buyRequestArray = $requestParams->toArray();
        }
        $filetype = 'png';
        $projectId = $this->request->getParam('dh_project_id');
        $dh_project_approve = $this->request->getParam('dh_project_approve');

        if (isset($dh_project_approve) && $dh_project_approve == 'true') {

            $dhData = array();

            $huddleResponse = json_decode($this->Dhhelper->exportDesignHuddleFileData($projectId, null));
            // $huddleResponse = json_decode($this->Databgcol->getDesignHuddleFile($projectId,$filetype));
            //$logger->info('-------------------------------------------------');
            //$logger->info(print_r($huddleResponse,true));
            if ($huddleResponse->data->thumbnail_url) {
                $dhData['dh_file_path'] = $huddleResponse->data->thumbnail_url;
                $this->Dhhelper->saveDesignHudFile($huddleResponse->data->thumbnail_url, $projectId);
            } else {
                $dhData['dh_file_path'] = '';
            }
            $item = $observer->getQuoteItem();
            $quote_id = $item->getQuoteId();
            $proquoteId = '';

            //  $quoteId = $observer->getData('quote_item')->getQuoteId();
            $quote = $this->quoteFactory->create()->load($quote_id);
            // Get the quote item collection
            $quoteItems = $quote->getAllVisibleItems();
            foreach ($quoteItems as $quoteC) {
                $proquoteId = $quoteC->getProductId();
                break;
            }


            $quoteItemCollection = $this->quoteFactory->create();
            $quoteItem = $quoteItemCollection->load($item->getId());
            foreach ($quoteItem as $quoteC) {
                $proquoteId = $quoteC->getProductId();
            }
            /*$writer = new \Zend_Log_Writer_Stream(BP . '/var/log/DesignHuddleLogNEW.log');
                $logger = new \Zend_Log();
                $logger->addWriter($writer);
                $logger->info($proquoteId); */
            //$logger->info($huddleResponse->data->download_url);

            // $proquoteId = $this->Databgcol->getQuoteCollection($item->getId());
            $dhData['order_id'] = '';
            $dhData['quote_id'] = $quote_id;


            if ($this->customerSession->isLoggedIn()) {
                $customer_id = $this->customerSession->getCustomer()->getId();
            } else {
                $customer_id = '';
            }

            $dhData['customer_id'] = $customer_id;
            $productId = $observer->getEvent()->getProduct()->getId();

            $dhData['project_title'] = $observer->getEvent()->getProduct()->getSku();
            $dhData['product_id'] =  $proquoteId; //$quoteItemCollect->getProductId();
            $dhData['dh_project_id'] = $projectId;
            $dhData['dh_file'] = $filetype;
            $dhData['dh_template_id'] = '';
            $dhData['product_img'] = '';
            $dhData['order_status'] = '0';
            $dhData['item_id'] = $item->getId();
            if ($dhData) {
                $model = $this->CustomDesignModel->create();
                $model->setData($dhData)->save();
            }
            $this->messageManager->addSuccessMessage(__("Custom Design Saved Successfully!!!"));
            return $this;
        }
        /* } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e, __("We can\'t submit your request, Please try again."));
            return $this;;
        } */
    }
}
