<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Block\Adminhtml\Shippingrules\Quote\Edit\Tab;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Form\Renderer\Fieldset;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Data\Form;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;

class Conditions extends Generic implements
    TabInterface
{
    public const EDIT_RULES_CONDITIONS_ADMIN_RESOURCE = 'MageWorx_ShippingRules::edit_rules_conditions';

    /**
     * Core registry
     *
     * @var Fieldset
     */
    protected $rendererFieldset;

    /**
     * @var \Magento\Rule\Block\Conditions
     */
    protected $conditions;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param \Magento\Rule\Block\Conditions $conditions
     * @param Fieldset $rendererFieldset
     * @param array $data
     */
    public function __construct(
        Context                        $context,
        Registry                       $registry,
        FormFactory                    $formFactory,
        \Magento\Rule\Block\Conditions $conditions,
        Fieldset                       $rendererFieldset,
        array                          $data = []
    ) {
        $this->rendererFieldset = $rendererFieldset;
        $this->conditions       = $conditions;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /** {@inheritdoc} */
    public function getTabLabel()
    {
        return __('Conditions');
    }

    /** {@inheritdoc} */
    public function getTabTitle()
    {
        return __('Conditions');
    }

    /** {@inheritdoc} */
    public function canShowTab()
    {
        return true;
    }

    /** {@inheritdoc} */
    public function isHidden()
    {
        return false;
    }

    /**
     * Prepare form before rendering HTML
     *
     * @return $this
     */
    protected function _prepareForm()
    {
        $model = $this->_coreRegistry->registry('current_promo_quote_rule');

        /** @var Form $form */
        $form = $this->_formFactory->create();
        $form->setHtmlIdPrefix('rule_');

        $renderer = $this->rendererFieldset->setTemplate(
            'MageWorx_ShippingRules::rule/conditions.phtml'
        )->setNewChildUrl(
            $this->getUrl('mageworx_shippingrules/shippingrules_quote/newConditionHtml/form/rule_conditions_fieldset')
        )->setNameInLayout(
            'shippingrules_quote_edit_tab_conditions_fieldset'
        );

        $fieldset = $form->addFieldset(
            'conditions_fieldset',
            [
                'legend' => __(
                    'Apply the rule only if the following conditions are met (leave blank for all products).'
                ),
                'class'  => 'fieldset'
            ]
        )->setRenderer(
            $renderer
        );

        $fieldset->addField(
            'conditions',
            'text',
            ['name' => 'conditions', 'label' => __('Conditions'), 'title' => __('Conditions')]
        )->setRule(
            $model
        )->setRenderer(
            $this->conditions
        );

        $fieldset->setReadonly(
            !$this->getAuthorization()->isAllowed(
                static::EDIT_RULES_CONDITIONS_ADMIN_RESOURCE
            )
        );

        $form->setValues($model->getData());
        $this->setForm($form);

        return parent::_prepareForm();
    }
}
