/**
 * Copyright © MageWorx, Inc. All rights reserved.
 * See LICENSE.txt for license details.
 */
define([
    'jquery',
    'uiComponent',
    'uiRegistry',
    'ko',
    'mage/translate'
], function ($, Component, registry, ko, $t) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'MageWorx_ShippingCalculatorBase/view/submit-button',
            label: $t('Get Shipping Methods'),
            skipValidation: true
        },

        selectedChoice: ko.observable(),

        initialize: function () {
            this._super();
        },

        /**
         * Initialize observables properties
         *
         * @returns {exports}
         */
        initObservable: function () {
            this._super();
            this.observe('label');

            return this;
        },

        /**
         * Send request to the server to obtain available shipping methods for the selected address
         */
        refreshForm: function () {
            var form = this.getForm();
            form.estimateShippingMethods();
        },

        /**
         * Returns the shipping calculator instance from registry
         *
         * @returns {Object}
         */
        getCalculator: function () {
            return registry.get('index = shipping-calculator');
        },

        /**
         * Returns form
         *
         * @returns {Object}
         */
        getForm: function () {
            return registry.get('shipping-calculator.estimateForm');
        }
    });
});
