/**
 * Copyright © MageWorx, Inc. All rights reserved.
 * See LICENSE.txt for license details.
 */
define([
    'uiLayout'
], function (layout) {
    'use strict';

    /**
     * Method generator. Used in methods-list generateNewMethod function.
     */
    return function(parent, options) {

        if (!options.template) {
            options.template = 'MageWorx_ShippingCalculatorBase/view/methods/method';
        }

        if (!options.component) {
            options.component = 'MageWorx_ShippingCalculatorBase/js/view/methods/method';
        }

        var newMethod = {
            parent: parent.name,
            name: parent.name + '.' + options.name,
            provider: parent.provider,
            displayArea: 'methods',
            component: options.component,
            config: options
        };

        layout([newMethod]);

        return this;
    };
});
