<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\DeliveryDate\Api;

use Magento\Framework\Exception\LocalizedException;
use MageWorx\DeliveryDate\Api\Data\DeliveryDateDataInterface;
use MageWorx\DeliveryDate\Api\Data\QueueDataInterface;
use MageWorx\DeliveryDate\Exceptions\QueueException;

/**
 * Interface QueueManagerInterface
 *
 */
interface QueueManagerInterface
{
    /**
     * @param int $addressId
     * @return QueueDataInterface|null
     */
    public function getByQuoteAddressId($addressId);

    /**
     * @param int $addressId
     * @return QueueDataInterface
     */
    public function getByOrderAddressId($addressId);

    /**
     * @param QueueDataInterface $queue
     * @param array $data
     * @return QueueManagerInterface
     * @throws QueueException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function updateQueue(QueueDataInterface $queue, array $data = []);

    /**
     * Check: is a selected delivery time is over a limit?
     *
     * @param DeliveryOptionInterface $deliveryOption
     * @param \DateTime $day
     * @param int $hoursFrom
     * @param int $hoursTo
     * @param int $minutesFrom
     * @param int $minutesTo
     * @return bool
     */
    public function isLimitExceeded(
        DeliveryOptionInterface $deliveryOption,
        \DateTime               $day,
                                $hoursFrom = 0,
                                $hoursTo = 0,
                                $minutesFrom = 0,
                                $minutesTo = 0
    );

    /**
     * Return selected delivery date for specified cart
     *
     * @param int $cartId
     * @return DeliveryDateDataInterface|null
     */
    public function getSelectedDeliveryDateByCartId(int $cartId);

    /**
     * Return selected delivery date for specified guest cart
     *
     * @param string $cartId
     * @return QueueDataInterface|null
     */
    public function getSelectedDeliveryDateByGuestCartId(string $cartId);

    /**
     * Set delivery date and time for cart
     *
     * @param int $cartId
     * @param DeliveryDateDataInterface $deliveryDateData
     * @return DeliveryDateDataInterface|null
     * @throws LocalizedException|QueueException
     */
    public function setDeliveryDateForCart(
        int                       $cartId,
        DeliveryDateDataInterface $deliveryDateData
    );

    /**
     * Set delivery date and time for guest cart
     *
     * @param string $cartId
     * @param DeliveryDateDataInterface $deliveryDateData
     * @return DeliveryDateDataInterface|null
     * @throws LocalizedException|QueueException
     */
    public function setDeliveryDateForGuestCart(
        string                    $cartId,
        DeliveryDateDataInterface $deliveryDateData
    );
}
