<?php
namespace BG\DesignHuddle\Helper;

use BG\DesignHuddle\Model\CustomDesign;
use Magento\Quote\Model\ResourceModel\Quote\Item\CollectionFactory;

class Databgcollect extends \Magento\Framework\App\Helper\AbstractHelper
{

    protected CustomDesign $customDesign;

    protected CollectionFactory $quoteFactory;

    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        CollectionFactory $quoteFactory,
        CustomDesign $CustomDesign
    ) {
        $this->customDesign = $CustomDesign;
        $this->quoteFactory = $quoteFactory;
        parent::__construct($context);
    }
    public function getMyCollection(){
        return "getMyCollection";

    }
    public function getBgCollection($orderId,$productId)
    {
        return $this->customDesign->getCollection()
                    ->addFieldToFilter('order_id',$orderId)
                    ->addFieldToFilter('product_id',$productId);
    }
    public function getLastDesignData($orderId,$productId)
    {
    	$collection =$this->customDesign->getCollection()
                    ->addFieldToFilter('order_id',$orderId)
                    ->addFieldToFilter('product_id',$productId)
                    ->setOrder('id', 'DESC');
        $collection->setPageSize(1);
        return $collection->getFirstItem();
    }
    public function getBgImagehuddle($itemQuoteId,$productId)
    {
        return $this->customDesign->getCollection()
                    ->addFieldToFilter('quote_id',$itemQuoteId)
                    ->addFieldToFilter('product_id',$productId);
    }

    public function getHuddleDesignItem($itemQuoteId, $itemId,$productId)
    {
        return $this->customDesign->getCollection()
                    ->addFieldToFilter('quote_id',$itemQuoteId)
                    ->addFieldToFilter('item_id',$itemId)
                    ->addFieldToFilter('product_id',$productId);
    }
    public function getQuoteCollection($itemId)
    {
        $quoteItemCollection = $this->quoteFactory;
        $quoteItem= $quoteItemCollection->addFieldToSelect('*')
                ->addFieldToFilter('item_id', $itemId)/*->getFirstItem()*/;

       // $quoteItemOptions = $quoteItem->getOptions();
        foreach($quoteItem as $quoteC){
            $proquoteId = $quoteC->getProductId();
        }
       return $proquoteId;
    }

    public function getBgCollectionByQuoteId($quoteId,$productId)
    {
        return $this->customDesign->getCollection()
                    ->addFieldToFilter('quote_id',$quoteId)
                    ->addFieldToFilter('product_id',$productId);
    }
}
