<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Model\System\Config\Source\Consent;

class Engine implements \Magento\Framework\Data\OptionSourceInterface
{
    const ENGINE_DISABLED   = 0;
    const ENGINE_BUILT_IN   = 1;
    const ENGINE_COOKIEBOT  = 2;
    const ENGINE_COOKIEYES  = 3;
	const ENGINE_ONETRUST 	= 4;
	const ENGINE_OTHER		= 5;

	/**
	 * @return []
	 */
	public function toOptionArray()
	{
		return 
		[
			[
				'value' => static::ENGINE_DISABLED, 
				'label' => __('No')
			],
			[
				'value' => static::ENGINE_BUILT_IN, 
				'label' => __('Yes, built-in (requires additional configurations)')
            ],
            [
				'value' => static::ENGINE_COOKIEBOT, 
				'label' => __('Yes, using CookieBot')
			],
            [
				'value' => static::ENGINE_COOKIEYES, 
				'label' => __('Yes, using CookieYes')
			],
			[
				'value' => static::ENGINE_ONETRUST, 
				'label' => __('Yes, using Onetrust')
			],
			[
				'value' => static::ENGINE_OTHER, 
				'label' => __('Yes, other.')
			]
		];
	}
}