<?php
namespace Magento\Quote\Api\Data;

/**
 * Extension class for @see \Magento\Quote\Api\Data\AddressInterface
 */
class AddressExtension extends \Magento\Framework\Api\AbstractSimpleObject implements AddressExtensionInterface
{
    /**
     * @return string|null
     */
    public function getPickupLocationCode()
    {
        return $this->_get('pickup_location_code');
    }

    /**
     * @param string $pickupLocationCode
     * @return $this
     */
    public function setPickupLocationCode($pickupLocationCode)
    {
        $this->setData('pickup_location_code', $pickupLocationCode);
        return $this;
    }

    /**
     * @return \Magento\SalesRule\Api\Data\RuleDiscountInterface[]|null
     */
    public function getDiscounts()
    {
        return $this->_get('discounts');
    }

    /**
     * @param \Magento\SalesRule\Api\Data\RuleDiscountInterface[] $discounts
     * @return $this
     */
    public function setDiscounts($discounts)
    {
        $this->setData('discounts', $discounts);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryDay()
    {
        return $this->_get('delivery_day');
    }

    /**
     * @param string $deliveryDay
     * @return $this
     */
    public function setDeliveryDay($deliveryDay)
    {
        $this->setData('delivery_day', $deliveryDay);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryHoursFrom()
    {
        return $this->_get('delivery_hours_from');
    }

    /**
     * @param string $deliveryHoursFrom
     * @return $this
     */
    public function setDeliveryHoursFrom($deliveryHoursFrom)
    {
        $this->setData('delivery_hours_from', $deliveryHoursFrom);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryMinutesFrom()
    {
        return $this->_get('delivery_minutes_from');
    }

    /**
     * @param string $deliveryMinutesFrom
     * @return $this
     */
    public function setDeliveryMinutesFrom($deliveryMinutesFrom)
    {
        $this->setData('delivery_minutes_from', $deliveryMinutesFrom);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryHoursTo()
    {
        return $this->_get('delivery_hours_to');
    }

    /**
     * @param string $deliveryHoursTo
     * @return $this
     */
    public function setDeliveryHoursTo($deliveryHoursTo)
    {
        $this->setData('delivery_hours_to', $deliveryHoursTo);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryMinutesTo()
    {
        return $this->_get('delivery_minutes_to');
    }

    /**
     * @param string $deliveryMinutesTo
     * @return $this
     */
    public function setDeliveryMinutesTo($deliveryMinutesTo)
    {
        $this->setData('delivery_minutes_to', $deliveryMinutesTo);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryComment()
    {
        return $this->_get('delivery_comment');
    }

    /**
     * @param string $deliveryComment
     * @return $this
     */
    public function setDeliveryComment($deliveryComment)
    {
        $this->setData('delivery_comment', $deliveryComment);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryTime()
    {
        return $this->_get('delivery_time');
    }

    /**
     * @param string $deliveryTime
     * @return $this
     */
    public function setDeliveryTime($deliveryTime)
    {
        $this->setData('delivery_time', $deliveryTime);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDeliveryOptionId()
    {
        return $this->_get('delivery_option_id');
    }

    /**
     * @param string $deliveryOptionId
     * @return $this
     */
    public function setDeliveryOptionId($deliveryOptionId)
    {
        $this->setData('delivery_option_id', $deliveryOptionId);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getQuoteAddressId()
    {
        return $this->_get('quote_address_id');
    }

    /**
     * @param string $quoteAddressId
     * @return $this
     */
    public function setQuoteAddressId($quoteAddressId)
    {
        $this->setData('quote_address_id', $quoteAddressId);
        return $this;
    }
}
