<?php
namespace WeltPixel\NavigationLinks\Model;

use Magento\CatalogUrlRewrite\Model\CategoryUrlRewriteGenerator;

class CategoryFlat extends \Magento\Catalog\Model\ResourceModel\Category\Flat
{
    /**
     * Return parent categories of category
     *
     * @param \Magento\Catalog\Model\Category $category
     * @param bool $isActive
     * @return \Magento\Catalog\Model\Category[]
     */
    public function getParentCategories($category, $isActive = true)
    {
        $categories = [];
        $connection = $this->getConnection();
        $select = $connection->select()->from(
            ['main_table' => $this->getMainStoreTable($category->getStoreId())],
            ['main_table.entity_id', 'main_table.name', 'weltpixel_category_url']
        )->joinLeft(
            ['url_rewrite' => $this->getTable('url_rewrite')],
            'url_rewrite.entity_id = main_table.entity_id AND url_rewrite.is_autogenerated = 1'
            . $connection->quoteInto(' AND url_rewrite.store_id = ?', $category->getStoreId())
            . $connection->quoteInto(' AND url_rewrite.entity_type = ?', CategoryUrlRewriteGenerator::ENTITY_TYPE),
            ['request_path' => 'url_rewrite.request_path']
        )->where(
            'main_table.entity_id IN (?)',
            array_reverse(explode(',', $category->getPathInStore()))
        );
        if ($isActive) {
            $select->where('main_table.is_active = ?', '1');
        }
        $select->order('main_table.path ASC');
        $result = $this->getConnection()->fetchAll($select);
        foreach ($result as $row) {
            $row['id'] = $row['entity_id'];
            $categories[$row['entity_id']] = $this->_categoryFactory->create()->setData($row);
        }
        return $categories;
    }
}
