<?php
namespace Mageplaza\CustomForm\Controller\Ajax;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\Session\SessionManager;

class Token extends Action
{
    protected $jsonFactory;
    protected $session;

    public function __construct(
        Context $context,
        JsonFactory $jsonFactory,
        SessionManager $session
    ) {
        parent::__construct($context);
        $this->jsonFactory = $jsonFactory;
        $this->session = $session;
    }

    public function execute()
    {
        $result = $this->jsonFactory->create();
        $token = $this->session->getData('secure_form_token');

        if (!$token) {
            $token = bin2hex(random_bytes(16));
            $this->session->setData('secure_form_token', $token);
        }

        return $result->setData(['token' => $token]);
    }
}

