<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Ui\Component\Listing\Columns;

use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

class CarrierActions extends Column
{
    /**
     * Url path  to edit
     *
     * @var string
     */
    public const URL_PATH_EDIT = 'mageworx_shippingrules/shippingrules_carrier/edit';

    /**
     * Url path  to delete
     *
     * @var string
     */
    public const URL_PATH_DELETE = 'mageworx_shippingrules/shippingrules_carrier/delete';

    /**
     * URL builder
     *
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * Constructor
     *
     * @param UrlInterface $urlBuilder
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param array $components
     * @param array $data
     */
    public function __construct(
        UrlInterface       $urlBuilder,
        ContextInterface   $context,
        UiComponentFactory $uiComponentFactory,
        array              $components = [],
        array              $data = []
    ) {
        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (!isset($dataSource['data']['items'])) {
            return $dataSource;
        }

        foreach ($dataSource['data']['items'] as &$item) {
            if (!isset($item['carrier_id'])) {
                continue;
            }

            $item[$this->getData('name')] = [
                'edit'   => [
                    'href'  => $this->urlBuilder->getUrl(
                        static::URL_PATH_EDIT,
                        [
                            'id' => $item['carrier_id'],
                        ]
                    ),
                    'label' => __('Edit'),
                ],
                'delete' => [
                    'href'    => $this->urlBuilder->getUrl(
                        static::URL_PATH_DELETE,
                        [
                            'id' => $item['carrier_id'],
                        ]
                    ),
                    'label'   => __('Delete'),
                    'confirm' => [
                        'title'         => __('Delete "${ $.$data.name }"'),
                        'message'       => __('Are you sure you wan\'t to delete the carrier "${ $.$data.name }" ?'),
                        '__disableTmpl' => [
                            'title'   => false,
                            'message' => false
                        ]
                    ],
                ],
            ];
        }

        return $dataSource;
    }
}
