/**
 * Copyright © MageWorx, Inc. All rights reserved.
 * See LICENSE.txt for license details.
 */
define([
    'underscore',
    'uiRegistry',
    'Magento_Ui/js/form/element/country'
], function (_, registry, CountrySelect) {
    'use strict';

    return CountrySelect.extend({
        defaults: {
            skipValidation: false
        },

        /**
         * Properties which will be set as an observable during initObservable method call
         */
        observableProperties: [
            'additionalClasses'
        ],

        /**
         * Initialize observables properties
         *
         * @returns {exports}
         */
        initObservable: function () {
            this._super();
            this.observe(this.observableProperties);

            return this;
        }
    });
});
