<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Observer\Cookie;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Anowave\Ec\Observer\Cookie as Cookie;

class Logout extends Cookie implements ObserverInterface
{
	/**
	 * @var \Magento\Customer\Model\Session
	 */
	protected $session;

	/**
	 * Cosntructor 
	 * 
	 * @param \Anowave\Ec\Helper\Data $helper
	 * @param \Anowave\Ec\Model\Cookie\PrivateData $privateData
	 * @param \Magento\Framework\Json\Helper\Data $jsonHelper
	 */
	public function __construct
	(
		\Anowave\Ec\Helper\Data $helper,
		\Anowave\Ec\Model\Cookie\PrivateData $privateData,
		\Anowave\Ec\Helper\Json $jsonHelper,
		\Magento\Framework\App\Request\Http $request,
		\Magento\Customer\Model\SessionFactory $sessionFactory
	)
	{
		parent::__construct($helper ,$privateData, $jsonHelper, $request);

		$this->session = $sessionFactory->create();
	}

	


	/**
	 * Execute (non-PHPdoc)
	 *
	 * @see \Magento\Framework\Event\ObserverInterface::execute()
	 */
	public function execute(EventObserver $observer)
	{
		try
		{
			$this->privateData->delete();

			$this->session->setCustomerLogoutEvent($this->jsonHelper->encode(
			[
				'event' 			=>    'logout',
				'eventCategory' 	=> __('Customer'),
				'eventAction' 		=> __('Logout'),
				'eventLabel' 		=> __('Authentication'),
				'eventValue' 		=> 1
			]));

		}
		catch (\Exception $e){}
	}
}