<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */
 
namespace Anowave\Ec\Controller\Index;

use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;


class Ads extends Action implements CsrfAwareActionInterface, HttpPostActionInterface, HttpGetActionInterface
{

    /**
     * @var \Anowave\Ec\Model\Ads
     */
    protected $ads;

    /**
     * Constructor
     */
	public function __construct
	(
		Context $context,
        \Anowave\Ec\Model\Ads $ads
	)
	{
		parent::__construct($context);
		
		$this->ads = $ads;
	}

	/**
	 * Execute controller
	 *
	 * @see \Magento\Framework\App\ActionInterface::execute()
	 */
	public function execute()
	{ 
		return false;
	}
	
	/**
	 * Create CSRF Exception
	 *
	 * {@inheritDoc}
	 * @see \Magento\Framework\App\CsrfAwareActionInterface::createCsrfValidationException()
	 */
	public function createCsrfValidationException(RequestInterface $request): ? InvalidRequestException
	{
	    return null;
	}
	
	/**
	 * Validate for CSRF
	 *
	 * {@inheritDoc}
	 * @see \Magento\Framework\App\CsrfAwareActionInterface::validateForCsrf()
	 */
	public function validateForCsrf(RequestInterface $request): ? bool
	{
	    return true;
	}
}